/***************************************************************************
 * 
 * Copyright (c) 2018 Baidu.com, Inc. All Rights Reserved
 * 
 **************************************************************************/

/**
 * @brief demo
 *
 **/

#include <iostream>
#include <sstream>
#include "easyedge/easyedge.h"
#include "easyedge/easyedge_config.h"
#include "easyedge/easyedge_gpu_turbo_config.h"

using namespace easyedge;

int main(int argc, char *argv[]) {

    if (argc < 3) {
        std::cerr << "Usage: ./easyedge_serving {res_dir} {serial_num} {host, default 0.0.0.0} {port, default 24401}" << std::endl;
        exit(-1);
    }

    std::string host = "0.0.0.0";
    int port = 24401;
    std::string service_id = "";
    std::string res_dir = argv[1];
    std::string serial_num = argv[2];

    if (argc >= 4) {
        host = argv[3];
    }
    if (argc >= 5) {
        port = std::stoi(argv[4]);
    }
    if (argc >= 6) {
        service_id = argv[5];
    }

    EdgeLogConfig log_config;
    log_config.enable_debug = false;
    global_controller()->set_log_config(log_config);

    EdgePredictorConfig config;
    config.model_dir = res_dir;
    config.set_config(params::PREDICTOR_KEY_SERIAL_NUM, serial_num);
    config.set_config(params::PREDICTOR_KEY_GTURBO_MAX_BATCH_SIZE, 1);  // 优化的模型可以支持的最大batch_size，实际单次推理的图片数不能大于此值
    config.set_config(params::PREDICTOR_KEY_GTURBO_MAX_CONCURRENCY, 1); // 设置device对应的卡可以使用的最大线程数
    config.set_config(params::PREDICTOR_KEY_GTURBO_FP16, false);        // 置true开启fp16模式推理会更快，精度会略微降低，但取决于硬件是否支持fp16，不是所有模型都支持fp16，参阅文档
    config.set_config(params::PREDICTOR_KEY_GTURBO_COMPILE_LEVEL, 1);   // 编译模型的策略，如果当前设置的max_batch_size与历史编译存储的不同，则重新编译模型

    return global_controller()->start_http_server(config, host, port, service_id, 1);
}